package com.example.sefinsa_app.utilities;

import static com.example.sefinsa_app.utilities.PrinterCommands.ESC_ALIGN_CENTER;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;


import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;

import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Prestamo;
import com.google.gson.Gson;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * Created by JOHNHY on 27/02/2018.
 */

public class BluetoothPrint  extends AppCompatActivity {

    // android built in classes for bluetooth operations
    BluetoothAdapter mBluetoothAdapter;
    BluetoothSocket mmSocket;
    BluetoothDevice mmDevice;

    // needed for communication to bluetooth device / network
    OutputStream mmOutputStream;
    InputStream mmInputStream;
    Thread workerThread;

    byte[] readBuffer;
    int readBufferPosition;
    volatile boolean stopWorker;
    byte FONT_TYPE;

    public static String printer_id;

    private final Context ctx;
    private final Resources resources;

    public BluetoothPrint(Context ctx, Resources resources) {
        this.ctx = ctx;
        this.resources = resources;
    }

    public void findBT() {
        System.out.println("Printer ID : " + printer_id);
        try {
            mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (mBluetoothAdapter == null) {
                Toast.makeText(ctx, "Error con bluetooth", Toast.LENGTH_SHORT).show();
            }
            if (!mBluetoothAdapter.isEnabled()) {
                Intent enableBluetooth = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                Toast.makeText(ctx, "Debes activar el blueetooth para la impresión de tickets", Toast.LENGTH_LONG).show();
                if (ActivityCompat.checkSelfPermission(ctx, Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED) {
                    // TODO: Consider calling
                    //    ActivityCompat#requestPermissions
                    // here to request the missing permissions, and then overriding
                    //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
                    //                                          int[] grantResults)
                    // to handle the case where the user grants the permission. See the documentation
                    // for ActivityCompat#requestPermissions for more details.
                    return;
                }
                startActivityForResult(enableBluetooth, 0);
            }
            Set<BluetoothDevice> pairedDevices = mBluetoothAdapter.getBondedDevices();
            if (pairedDevices.size() > 0) {
                for (BluetoothDevice device : pairedDevices) {
                    Log.d("DEVICE", device.getName());
                    if (device.getName().equals(printer_id)) {
                        mmDevice = device;
                        break;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // tries to open a connection to the bluetooth printer device
    public void openBT() throws IOException {
        try {
            // Standard SerialPortService ID
            if (ActivityCompat.checkSelfPermission(ctx, Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED) {
                // TODO: Consider calling
                //    ActivityCompat#requestPermissions
                // here to request the missing permissions, and then overriding
                //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
                //                                          int[] grantResults)
                // to handle the case where the user grants the permission. See the documentation
                // for ActivityCompat#requestPermissions for more details.
                return;
            }
            UUID uuid = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
            mmSocket = mmDevice.createRfcommSocketToServiceRecord(uuid);
            mmSocket.connect();
            mmOutputStream = mmSocket.getOutputStream();
            mmInputStream = mmSocket.getInputStream();
            beginListenForData();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printQrCode(Bitmap qRBit) {
        try {
            PrintPic printPic1 = PrintPic.getInstance();
            printPic1.init(qRBit);
            byte[] bitmapdata2 = printPic1.printDraw();
            mmOutputStream.write(bitmapdata2);
        }
        catch(Exception e){
            e.printStackTrace();
        }
    }

    public boolean isConnected(){

        return mmSocket.isConnected();
    }

    public void printText(Pago pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra){
        try {
            /*String fechaConvert = fecha.split("-")[2] + "/" + fecha.split("-")[1] + "/"
                    + fecha.split("-")[0];*/

            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());

            String text = "--------------------------\n";
            text += "Folio: "+ folio+"\n";
            text += "Impresión: "+fechaConvert+"\n";
            text += "Ruta: "+pago.getNombre_ruta()+"\n";
            text += "Poblacion: "+pago.getNombre_poblacion()+"\n";
            text += "Recibi de: "+pago.getNombre_completo()+"\n";
            text += "Cantidad: $"+recibido + "\n";
            text += "("+recibido_con_letra + "PESOS 00/100 MN)"+ "\n";
            text += "Debe: $"+ (Utils.convertirDouble(pago.getBalance()) - Utils.convertirDouble(recibido)) + "\n";
            if(pago_multa != "0.0") text += "Multa: $"+ pago_multa + "\n";
            text += "Concepto: "+concepto+"\n";
            text += "--------------------------\n";
            mmOutputStream.write(text.getBytes());
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    public void printText(String titulo_ticket, String ruta_ticket, String Poblacion_ticket, String Nombre_ticket, String Atraso_ticket, String pago_ticket, String aviso){
        try {
            /*String fechaConvert = fecha.split("-")[2] + "/" + fecha.split("-")[1] + "/"
                    + fecha.split("-")[0];*/

            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());

            String text = "--------------------------\n";
            text += titulo_ticket+"\n";
            text += fechaConvert+"\n";

            text += ruta_ticket+"\n";
            text += Poblacion_ticket +"\n";
            text += Nombre_ticket +"\n";
            text += Atraso_ticket + "\n";
            text += pago_ticket+ "\n";
            //text += "Debe: $"+ (Double.parseDouble(pago.getBalance()) - Double.parseDouble(recibido)) + "\n";
            //if(pago_multa != "0.0") text += "Multa: $"+ pago_multa + "\n";
            text += aviso+"\n";
            text += "--------------------------\n";
            mmOutputStream.write(text.getBytes());
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    public void printText(Prestamo pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra){
        try {
            /*String fechaConvert = fecha.split("-")[2] + "/" + fecha.split("-")[1] + "/"
                    + fecha.split("-")[0];*/

            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());


            String text = "--------------------------\n";
            text += "Folio: "+ folio+"\n";
            text += fechaConvert+"\n";
            text += "Ruta: "+pago.getNombre_ruta()+"\n";
            text += "Poblacion: "+pago.getNombre_poblacion()+"\n";
            text += "Recibi de: "+pago.getNombre_completo()+"\n";
            text += "Cantidad: $"+recibido + "\n";
            text += "("+recibido_con_letra + "PESOS 00/100 MN)"+ "\n";
            //text += "Debe: $"+ (Double.parseDouble(pago.getBalance()) - Double.parseDouble(recibido)) + "\n";
            if(pago_multa != "0.0") text += "Multa: $"+ pago_multa + "\n";
            text += "Concepto: "+concepto+"\n";
            text += "--------------------------\n";
            mmOutputStream.write(text.getBytes());
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    public void printReporteGeneral(ArrayList<PagosHechos> pagosHechos, String fecha){

        try {

            String text = "\nREPORTE GENERAL "+fecha+"\n\n";

            double total = 0;
            for(PagosHechos pagoHecho : pagosHechos){
                total += Utils.convertirDouble(pagoHecho.getCobro());
            }
            text+= "TOTAL: $" + total + "\n\n";

            Map<String, List<PagosHechos>> pagosHechosGroup =
                    pagosHechos.stream().collect(Collectors.groupingBy(w -> w.getPoblacion()));

            for(Map.Entry<String, List<PagosHechos>> entry : pagosHechosGroup.entrySet()) {
                String key = entry.getKey();
                List<PagosHechos> value = entry.getValue();

                text+=key +"\n";

                for (int i = 0; i < value.size(); i++) {
                    Gson gson = new Gson();
                    PagosHechos pagoHecho = gson.fromJson(value.get(i).toString(), PagosHechos.class);

                    text+= pagoHecho.getCliente() + ": $" + pagoHecho.getCobro()+ " " ;
                    text+= pagoHecho.getFolio()  + " " + pagoHecho.getConcepto() +"\n\n";
                }

            }



            Log.d("REPORTE", text);

            mmOutputStream.write(text.getBytes());

        }catch(Exception e){
            e.printStackTrace();
        }

    }

    public void printStruk(String nama_produk, String pengiriman, String Date){
        System.out.println("Nama Produk: "+nama_produk);
        System.out.println("Barang: "+pengiriman);
        System.out.println("Date: "+Date);
        try {
            String text = "---------------------\n";
            text += "Produk : "+nama_produk+"\n";
            text += "Barang : "+pengiriman+"\n";
            text += "Tanggal: "+Date+"\n";
            mmOutputStream.write(text.getBytes());
        }catch(Exception e){
            e.printStackTrace();
        }
    }


    /*
     * after opening a connection to bluetooth printer device,
     * we have to listen and check if a data were sent to be printed.
     */
    public void beginListenForData() {
        try {
            final Handler handler = new Handler();
            // this is the ASCII code for a newline character
            final byte delimiter = 10;
            stopWorker = false;
            readBufferPosition = 0;
            readBuffer = new byte[1024];
            workerThread = new Thread(new Runnable() {
                public void run() {
                    while (!Thread.currentThread().isInterrupted() && !stopWorker) {
                        try {
                            int bytesAvailable = mmInputStream.available();
                            if (bytesAvailable > 0) {
                                byte[] packetBytes = new byte[bytesAvailable];
                                mmInputStream.read(packetBytes);
                                for (int i = 0; i < bytesAvailable; i++) {
                                    byte b = packetBytes[i];
                                    if (b == delimiter) {
                                        byte[] encodedBytes = new byte[readBufferPosition];
                                        System.arraycopy(
                                                readBuffer, 0,
                                                encodedBytes, 0,
                                                encodedBytes.length
                                        );
                                        // specify US-ASCII encoding
                                        final String data = new String(encodedBytes, StandardCharsets.US_ASCII);
                                        readBufferPosition = 0;
                                        // tell the user data were sent to bluetooth printer device
                                        handler.post(new Runnable() {
                                            public void run() {
//                                                myLabel.setText(data);
                                            }
                                        });
                                    } else {
                                        readBuffer[readBufferPosition++] = b;
                                    }
                                }
                            }
                        } catch (IOException ex) {
                            stopWorker = true;
                        }
                    }
                }
            });
            workerThread.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    //    this will update data printer name in ModelUser
    // close the connection to bluetooth printer.
    public void closeBT() throws IOException {
        try {
            stopWorker = true;
            mmOutputStream.close();
            mmInputStream.close();
            mmSocket.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void printPhoto(int img) {
        try {
            Bitmap bmp = BitmapFactory.decodeResource(resources,
                    img);
            if(bmp!=null){
                byte[] command = Utils.decodeBitmap(bmp);

                mmOutputStream.write(ESC_ALIGN_CENTER);
                mmOutputStream.write(command);

            }else{
                Log.e("Print Photo error", "the file isn't exists");
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e("EXE", e.toString());
            Log.e("PrintTools", "the file isn't exists");
        }
    }


    public static Bitmap decodeFile(File f, int WIDTH, int HIGHT){
        try {
            //Decode image size
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream(new FileInputStream(f),null,o);

            //The new size we want to scale to
            final int REQUIRED_WIDTH=WIDTH;
            final int REQUIRED_HIGHT=HIGHT;
            //Find the correct scale value. It should be the power of 2.
            int scale=1;
            while(o.outWidth/scale/2>=REQUIRED_WIDTH && o.outHeight/scale/2>=REQUIRED_HIGHT)
                scale*=2;

            //Decode with inSampleSize
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize=scale;
            return BitmapFactory.decodeStream(new FileInputStream(f), null, o2);
        }
        catch (FileNotFoundException e) {}
        return null;
    }

}